// Load Wi-Fi library
#include <WiFi.h>

// Replace with your network credentials
const char* ssid = "free";
const char* password = "123456789";

// Set web server port number to 80
WiFiServer server(80);

// Variable to store the HTTP request
String header;

// Auxiliar variables to store the current output state
String output26State = "خاموش";
String output27State = "خاموش";
String output25State = "خاموش";
String output14State = "خاموش";

// Assign output variables to GPIO pins
const int output26 = 26;
const int output27 = 27;
const int output25 = 25;
const int output14 = 14;

// Current time
unsigned long currentTime = millis();
// Previous time
unsigned long previousTime = 0; 
// Define timeout time in milliseconds (example: 2000ms = 2s)
const long timeoutTime = 2000;

void setup() {
  Serial.begin(115200);
  // Initialize the output variables as outputs
  pinMode(output26, OUTPUT);
  pinMode(output27, OUTPUT);
  pinMode(output25, OUTPUT);
  pinMode(output14, OUTPUT);
  // Set outputs to LOW
  digitalWrite(output26, LOW);
  digitalWrite(output27, LOW);
  digitalWrite(output25, LOW);
  digitalWrite(output14, LOW);

  // Connect to Wi-Fi network with SSID and password
  Serial.print("Connecting to ");
  Serial.println(ssid);
  WiFi.begin(ssid, password);
  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    Serial.print(".");
  }
  // Print local IP address and start web server
  Serial.println("");
  Serial.println("WiFi connected.");
  Serial.println("IP address: ");
  Serial.println(WiFi.localIP());
  server.begin();
}

void loop(){
  WiFiClient client = server.available();   // Listen for incoming clients

  if (client) {                             // If a new client connects,
    currentTime = millis();
    previousTime = currentTime;
    Serial.println("New Client.");          // print a message out in the serial port
    String currentLine = "";                // make a String to hold incoming data from the client
    while (client.connected() && currentTime - previousTime <= timeoutTime) {  // loop while the client's connected
      currentTime = millis();
      if (client.available()) {             // if there's bytes to read from the client,
        char c = client.read();             // read a byte, then
        Serial.write(c);                    // print it out the serial monitor
        header += c;
        if (c == '\n') {                    // if the byte is a newline character
          // if the current line is blank, you got two newline characters in a row.
          // that's the end of the client HTTP request, so send a response:
          if (currentLine.length() == 0) {
            // HTTP headers always start with a response code (e.g. HTTP/1.1 200 OK)
            // and a content-type so the client knows what's coming, then a blank line:
            client.println("HTTP/1.1 200 OK");
            client.println("Content-type:text/html");
            client.println("Connection: close");
            client.println();
            
            // turns the GPIOs on and off
            if (header.indexOf("GET /26/on") >= 0) {
              Serial.println("GPIO 26 on");
              output26State = "روشن";
              digitalWrite(output26, HIGH);
            } else if (header.indexOf("GET /26/off") >= 0) {
              Serial.println("GPIO 26 off");
              output26State = "خاموش";
              digitalWrite(output26, LOW);
            } else if (header.indexOf("GET /27/on") >= 0) {
              Serial.println("GPIO 27 on");
              output27State = "روشن";
              digitalWrite(output27, HIGH);
            } else if (header.indexOf("GET /27/off") >= 0) {
              Serial.println("GPIO 27 off");
              output27State = "خاموش";
              digitalWrite(output27, LOW);
            } else if (header.indexOf("GET /25/on") >= 0) {
              Serial.println("GPIO 25 on");
              output25State = "روشن";
              digitalWrite(output25, HIGH);
            } else if (header.indexOf("GET /25/off") >= 0) {
              Serial.println("GPIO 25 off");
              output25State = "خاموش";
              digitalWrite(output25, LOW);
            } else if (header.indexOf("GET /14/on") >= 0) {
              Serial.println("GPIO 14 on");
              output14State = "روشن";
              digitalWrite(output14, HIGH);
            } else if (header.indexOf("GET /14/off") >= 0) {
              Serial.println("GPIO 14 off");
              output14State = "خاموش";
              digitalWrite(output14, LOW);
            }
            
            // Display the HTML web page
            client.println("<!DOCTYPE html><html>");
            client.println("<head><meta name=\"viewport\" content=\"width=device-width, initial-scale=1\">");
            client.println("<meta charset='UTF-8'>");            
            client.println("<link rel=\"icon\" href=\"data:,\">");
            // CSS to style the on/off buttons 
            // Feel free to change the background-color and font-size attributes to fit your preferences
            client.println("<style>html { font-family: Helvetica; display: inline-block; margin: 0px auto; text-align: center;}");
            client.println(".button { background-color: #4CAF50; border: none; color: white; padding: 16px 40px;");
            client.println("text-decoration: none; font-size: 30px; margin: 2px; cursor: pointer;}");
            client.println(".button2 {background-color: #555555;}</style></head>");
            
            // Web Page Heading
            client.println("<body><h1>کنترل روشنایی</h1>");
            
            // Display current state, and ON/OFF buttons for GPIO 26  
            client.println("<p>وضعیت چراغ پورت 26 : " + output26State + "</p>");
            // If the output26State is off, it displays the ON button       
            if (output26State=="خاموش") {
              client.println("<p><a href=\"/26/on\"><button class=\"button\">روشن کن</button></a></p>");
            } else {
              client.println("<p><a href=\"/26/off\"><button class=\"button button2\">خاموش کن</button></a></p>");
            } 
               
            // Display current state, and ON/OFF buttons for GPIO 27  
            client.println("<p>وضعیت چراغ پورت 27 : " + output27State + "</p>");
            // If the output27State is off, it displays the ON button       
            if (output27State=="خاموش") {
              client.println("<p><a href=\"/27/on\"><button class=\"button\">روشن کن</button></a></p>");
            } else {
              client.println("<p><a href=\"/27/off\"><button class=\"button button2\">خاموش کن</button></a></p>");
            }

            // Display current state, and ON/OFF buttons for GPIO 27  
            client.println("<p>وضعیت چراغ پورت 14 : " + output14State + "</p>");
            // If the output14State is off, it displays the ON button       
            if (output14State=="خاموش") {
              client.println("<p><a href=\"/14/on\"><button class=\"button\">روشن کن</button></a></p>");
            } else {
              client.println("<p><a href=\"/14/off\"><button class=\"button button2\">خاموش کن</button></a></p>");
            }

            // Display current state, and ON/OFF buttons for GPIO 25  
            client.println("<p>وضعیت چراغ پورت 25 : " + output25State + "</p>");
            // If the output25State is off, it displays the ON button       
            if (output25State=="خاموش") {
              client.println("<p><a href=\"/25/on\"><button class=\"button\">روشن کن</button></a></p>");
            } else {
              client.println("<p><a href=\"/25/off\"><button class=\"button button2\">خاموش کن</button></a></p>");
            }

            client.println("</body></html>");
            
            // The HTTP response ends with another blank line
            client.println();
            // Break out of the while loop
            break;
          } else { // if you got a newline, then clear currentLine
            currentLine = "";
          }
        } else if (c != '\r') {  // if you got anything else but a carriage return character,
          currentLine += c;      // add it to the end of the currentLine
        }
      }
    }
    // Clear the header variable
    header = "";
    // Close the connection
    client.stop();
    Serial.println("Client disconnected.");
    Serial.println("");
  }
}
