import numpy as np
import face_recognition as fr
import cv2

videoCapture = cv2.VideoCapture(0)

ali_image = fr.load_image_file("train/ali-kiumarsi/1.jpg")
ali_face_encoding = fr.face_encodings(ali_image)[0]
hamed_image = fr.load_image_file("train/hamed-kharaj/1.jpg")
hamed_face_encoding = fr.face_encodings(hamed_image)[0]


know_face_encodings = [ali_face_encoding, hamed_face_encoding]
know_face_names = ["Ali Kiumarsi", "Hamed Kharaj"]

while True:
    ret, frame = videoCapture.read()

    rgb_freame = frame[:, :, ::-1]

    face_locations = fr.face_locations(rgb_freame)
    face_encodings = fr.face_encodings(rgb_freame, face_locations)

    for (top, right, bottom, left), face_encoding in zip(face_locations, face_encodings):
        matches = fr.compare_faces(know_face_encodings, face_encoding)

        name = "!!!"

        face_distances = fr.face_distance(know_face_encodings, face_encoding)

        best_match_index = np.argmin(face_distances)
        if matches[best_match_index]:
            name = know_face_names[best_match_index]

        cv2.rectangle(
            frame,
            (left, top),
            (right, bottom),
            (0, 0, 255),
            2
        )

        cv2.rectangle(
            frame,
            (left, bottom -35),
            (right, bottom),
            (0, 0, 255),
            cv2.FILLED
        )

        font = cv2.FONT_HERSHEY_SIMPLEX
        cv2.putText(frame, name, (left + 6, bottom - 6), font, 1.0, (255, 255, 255), 1)

    cv2.imshow("webcam-face-recognition", frame)

    if cv2.waitKey(1) & 0xFF == ord('q'):
        break

videoCapture.release() 
cv2.destroyAllWindows()